% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/financials.R
\name{get_financials}
\alias{get_financials}
\title{Get all financial statements for a ticker}
\usage{
get_financials(
  ticker,
  freq = "annual",
  start = NULL,
  end = NULL,
  cashflow_keys = NULL,
  balance_keys = NULL,
  income_keys = NULL,
  pretty = TRUE,
  wide = TRUE,
  proxy = NULL,
  output = c("tibble", "response", "request")
)
}
\arguments{
\item{ticker}{A ticker object created with \code{get_tickers()} or a ticker symbol string}

\item{freq}{Frequency of data: "annual" or "quarterly" (default "annual")}

\item{start}{Start timestamp as date, datetime, or string (default EOY 2016)}

\item{end}{End timestamp as date, datetime, or string (default current timestamp)}

\item{cashflow_keys}{Vector of specific cash flow statement keys to include (default all)
See \code{valid_cashflow_keys} for available options.}

\item{balance_keys}{Vector of specific balance sheet keys to include (default all)
See \code{valid_balance_keys} for available options.}

\item{income_keys}{Vector of specific income statement keys to include (default all)
See \code{valid_income_keys} for available options.}

\item{pretty}{Format column names to be more readable (default TRUE)}

\item{wide}{Return data in wide format with dates as columns (default TRUE).
If FALSE, returns data in long format with a date column.}

\item{proxy}{Optional proxy settings for the request}

\item{output}{Object to return. Can be "tibble", "response", or "request" (default "tibble")}
}
\value{
A list containing three elements:
\itemize{
\item \code{income_statement}: Income statement data
\item \code{balance_sheet}: Balance sheet data
\item \code{cashflow}: Cash flow statement data
}

If output is "request" or "response", returns a list of httr2 request or response objects instead.
}
\description{
Retrieves all three main financial statements (income statement, balance sheet, and
cash flow statement) from Yahoo Finance for a specified ticker symbol in a single call.
This is a convenience function that calls the individual statement functions and
returns the results as a list.
}
\details{
Note that this function makes multiple API calls to Yahoo Finance. Be aware of potential
rate limiting issues when making frequent requests. If you encounter HTTP 429 (Too Many Requests)
errors, consider implementing a delay between requests or using a proxy.
}
\examples{
\dontrun{
apple <- get_tickers("AAPL")

# Get all annual financial statements
financials <- get_financials(apple)

# Access individual statements from the results
income <- financials$income_statement
balance <- financials$balance_sheet
cashflow <- financials$cashflow

# Get all quarterly financial statements
quarterly_financials <- get_financials(apple, freq = "quarterly")

# Get financial statements for a specific time period
financials_2020_2022 <- get_financials(apple,
  start = "2020-01-01",
  end = "2022-12-31"
)
}
}
