% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tickers.R
\name{get_tickers_financials}
\alias{get_tickers_financials}
\title{Get all financial statements for multiple tickers}
\usage{
get_tickers_financials(
  tickers_obj,
  freq = c("annual", "quarterly"),
  start = NULL,
  end = NULL,
  cashflow_keys = NULL,
  balance_keys = NULL,
  income_keys = NULL,
  pretty = TRUE,
  wide = TRUE,
  proxy = NULL,
  output = c("tibble", "response", "request")
)
}
\arguments{
\item{tickers_obj}{A tickers object created with get_tickers()}

\item{freq}{Frequency of data: "annual" or "quarterly" (default "annual")}

\item{start}{Start timestamp as date, datetime, or string (default EOY 2016)}

\item{end}{End timestamp as date, datetime, or string (default current timestamp)}

\item{cashflow_keys}{Vector of specific cash flow statement keys to include (default all)
See \code{valid_cashflow_keys} for available options.}

\item{balance_keys}{Vector of specific balance sheet keys to include (default all)
See \code{valid_balance_keys} for available options.}

\item{income_keys}{Vector of specific income statement keys to include (default all)
See \code{valid_income_keys} for available options.}

\item{pretty}{Format column names to be more readable (default TRUE)}

\item{wide}{Return data in wide format with dates as columns (default TRUE).
If FALSE, returns data in long format with a date column.}

\item{proxy}{Optional proxy settings for the request}

\item{output}{Object to return. Can be "tibble", "response", or "request" (default "tibble")}
}
\value{
A nested list containing financial statements for each ticker
}
\description{
Get all financial statements for multiple tickers
}
\examples{
\dontrun{
tech_tickers <- get_tickers(c("AAPL", "MSFT", "GOOG"))
tech_financials <- get_tickers_financials(tech_tickers)
}
}
