% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabulate-yields.R
\name{ypr_tabulate_yields}
\alias{ypr_tabulate_yields}
\alias{ypr_tabulate_yields.default}
\alias{ypr_tabulate_yields.ypr_populations}
\title{Tabulate Yields}
\usage{
ypr_tabulate_yields(object, ...)

\method{ypr_tabulate_yields}{default}(
  object,
  pi = seq(0, 1, length.out = 100),
  Ly = 0,
  harvest = TRUE,
  biomass = FALSE,
  all = FALSE,
  ...
)

\method{ypr_tabulate_yields}{ypr_populations}(
  object,
  pi = seq(0, 1, length.out = 100),
  Ly = 0,
  harvest = TRUE,
  biomass = FALSE,
  all = FALSE,
  ...
)
}
\arguments{
\item{object}{The population or populations.}

\item{...}{Unused parameters.}

\item{pi}{A vector of probabilities of capture to calculate the yield for.}

\item{Ly}{The minimum length (trophy) fish to consider when calculating the
yield (cm).}

\item{harvest}{A flag specifying whether to calculate the yield for harvested
fish or captures.}

\item{biomass}{A flag specifying whether to calculate the yield in terms of
the biomass versus number of individuals.}

\item{all}{A flag specifying whether to include all parameter values.}
}
\value{
A data frame.
}
\description{
Tabulate Yields
}
\section{Methods (by class)}{
\itemize{
\item \code{ypr_tabulate_yields(default)}: Tabulate Yields

\item \code{ypr_tabulate_yields(ypr_populations)}: Tabulate Yields

}}
\examples{
ypr_tabulate_yields(ypr_population())
ypr_tabulate_yields(
  ypr_populations(
    Rk = c(3, 5)
  ),
  pi = seq(0, 1, length.out = 10)
)
ypr_tabulate_yields(ypr_ecotypes(Linf = c(10, 20)))
}
\seealso{
Other tabulate: 
\code{\link{ypr_detabulate_parameters}()},
\code{\link{ypr_report}()},
\code{\link{ypr_tabulate_biomass}()},
\code{\link{ypr_tabulate_fish}()},
\code{\link{ypr_tabulate_parameters}()},
\code{\link{ypr_tabulate_schedule}()},
\code{\link{ypr_tabulate_sr}()},
\code{\link{ypr_tabulate_yield}()}

Other populations: 
\code{\link{as_ypr_populations}()},
\code{\link{chilliwack_bt_05}},
\code{\link{ypr_plot_yield}()},
\code{\link{ypr_populations_expand}()},
\code{\link{ypr_populations}()},
\code{\link{ypr_tabulate_sr}()},
\code{\link{ypr_tabulate_yield}()}
}
\concept{populations}
\concept{tabulate}
