% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yield.R
\name{ypr_yield}
\alias{ypr_yield}
\title{Yield}
\usage{
ypr_yield(object, Ly = 0, harvest = TRUE, biomass = FALSE, ...)
}
\arguments{
\item{object}{The population or populations.}

\item{Ly}{The minimum length (trophy) fish to consider when calculating the
yield (cm).}

\item{harvest}{A flag specifying whether to calculate the yield for harvested
fish or captures.}

\item{biomass}{A flag specifying whether to calculate the yield in terms of
the biomass versus number of individuals.}

\item{...}{Unused parameters.}
}
\value{
The yield as number of fish or biomass.
}
\description{
Calculates the yield for a population.
}
\details{
By default, with \code{Rmax = 1} the number of individuals is the proportion of
the recruits at the carrying capacity. If the yield is given in terms of the
biomass (kg) then the scaling also depends on the value of \code{Wa} (g).
}
\examples{
ypr_yield(ypr_population())
ypr_yield(ypr_ecotypes(Linf = c(100, 200)))
}
\seealso{
Other yield: 
\code{\link{ypr_plot_yield}()},
\code{\link{ypr_tabulate_yield}()},
\code{\link{ypr_yields}()}

Other calculate: 
\code{\link{ypr_age_at_length}()},
\code{\link{ypr_exploitation}()},
\code{\link{ypr_length_at_age}()},
\code{\link{ypr_optimize}()},
\code{\link{ypr_yields}()}
}
\concept{calculate}
\concept{yield}
