% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zetadiv.R
\name{Zeta.scale.regular}
\alias{Zeta.scale.regular}
\title{Zeta diversity scaling with sample grain using hierarchical increases in grain size}
\usage{
Zeta.scale.regular(
  xy,
  data.spec,
  n,
  order = 1,
  sam = 1000,
  method = "mean",
  rescale = FALSE,
  normalize = FALSE,
  plot = TRUE,
  zeta.type = "exact"
)
}
\arguments{
\item{xy}{Site-by-coordinate data frame, with sites as rows and coordinates as columns.}

\item{data.spec}{Site-by-species presence-absence data frame, with sites as rows and species as columns.}

\item{n}{Vector of mapping grains: regularly spaced sites are grouped as \code{n[i]} x \code{n[i]} sites to generate data at a coarser grain.}

\item{order}{Specific number of assemblages or sites at which zeta diversity is computed.}

\item{sam}{Number of samples for which the zeta diversity is computed.}

\item{method}{Name of a function (as a string) indicating how to combine the coordinates. It can be a basic R-function such as "\code{mean}" or "\code{max}", but also a custom function.}

\item{rescale}{Boolean value (TRUE or FALSE) indicating if the zeta values should be divided by \eqn{\zeta_1}, to get a range of values between 0 and 1. Has no effect if \code{normalize} != \code{FALSE}.}

\item{normalize}{Indicates if the zeta values for each sample should be divided by the total number of species for this specific sample (\code{normalize = "Jaccard"}), by the average number of species per site for this specific sample (\code{normalize = "Sorensen"}), or by the minimum number of species in the sites of this specific sample \cr (\code{normalize = "Simpson"}). Default value is \code{FALSE}, indicating that no normalization is performed.}

\item{plot}{Boolean value (TRUE or FALSE) indicating if the outputs must be plotted.}

\item{zeta.type}{The function that must be used for the computation of zeta diversity. Default is "\code{exact}" for calling \code{Zeta.order.ex}. Use "\code{monte carlo}" for calling \code{Zeta.order.mc}.}
}
\value{
\code{Zeta.scale.regular} returns a list containing the following components:

\item{order}{The order of zeta.}

\item{n}{The vector of mapping grains: regularly spaced sites are grouped as \code{n[i]} x \code{n[i]} sites to generate data at a coarser grain.}

\item{values}{The zeta diversity values for each grain.}

\item{sd}{The standard deviation of zeta diversity for each grain.}
}
\description{
Computes zeta diversity scaling with sample grain for a specific order (number of assemblages or sites), increasing grain by hierarchically nesting of regularly spaced sites.
}
\details{
The sites (plots or quadrates) are incrementally aggregated as nearest neighbouring groups of 4, 9, etc. sites, using a nested approach, starting from the lowest x and y, to increase the grain. The sites can be spatially contiguous or discontiguous, as long as they are regularly spaced (see Scheiner et al., 2011). If the total number of sites is not a multiple of \code{n[i]} x \code{n[i]}, the extra sites are discarded.
}
\examples{
utils::data(bird.spec.fine)
xy.bird <- bird.spec.fine[1:400,1:2]
data.spec.bird <- bird.spec.fine[1:400,3:192]

dev.new()
##sam = 25 is used here for fast execution, but a higher value is advised
zeta.scale.reg <- Zeta.scale.regular(xy.bird, data.spec.bird, n = 1:3, order = 3,
    sam = 25, normalize = "Jaccard", zeta.type="monte carlo")
}
\references{
Hui C. & McGeoch M.A. (2014). Zeta diversity as a concept and metric that unifies incidence-based biodiversity patterns. \emph{The American Naturalist}, 184, 684-694.

Scheiner S.M., Chiarucci A., Fox G.A., Helmus M.R., McGlinn D.J. & Willig M.R. (2011). The underpinnings of the relationship of species richness with space and time. \emph{Ecological Monographs}, 81, 195-213.
}
\seealso{
\code{\link{Zeta.decline.mc}}, \code{\link{Zeta.order.mc}}, \code{\link{Zeta.decline.ex}}, \code{\link{Zeta.order.ex}}

\code{\link{Zeta.scale.min.dist}}, \code{\link{rescale.regular}}, \code{\link{rescale.min.dist}}
}
