% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sample_transcript_sentiment_syu}
\alias{sample_transcript_sentiment_syu}
\title{Parsed spoken language in a 'Zoom' meeting with syuzhet-based sentiment analysis.}
\format{
A data frame with 30 rows of 23 variables:
\describe{
\item{batchMeetingId}{a character meeting identification variable}
\item{utteranceId}{an incremented numeric identifier for a marked speech utterance}
\item{userName}{'Zoom' display name attached to this speaker}
\item{utteranceStartSeconds}{when the utterance started as the number of seconds from the start of the recording}
\item{utteranceStartTime}{timestamp for the start of the utterance}
\item{utteranceEndSeconds}{when the utterance ended as the number of seconds from the start of the recording}
\item{utteranceEndTime}{timestamp for the end of the utterance}
\item{utteranceTimeWindow}{duration of the utterance, in seconds}
\item{utteranceMessage}{the text of the utterance}
\item{utteranceLanguage}{language code of the utterance}
\item{userEmail}{character email address}
\item{userId}{numeric id of each speaker}
\item{wordCount}{number of words in this utterance}
\item{syu_anger}{number of anger words}
\item{syu_anticipation}{number of anticipation words}
\item{syu_disgust}{number of disgust words}
\item{syu_fear}{number of fear words}
\item{syu_joy}{number of joy words}
\item{syu_sadness}{number of sadness words}
\item{syu_surprise}{number of surprise words}
\item{syu_trust}{number of trust words}
\item{syu_negative}{number of negative words}
\item{syu_positive}{number of positive words}
}
}
\source{
\url{http://zoomgroupstats.org/}
}
\usage{
sample_transcript_sentiment_syu
}
\description{
Parsed spoken language in a 'Zoom' meeting with syuzhet-based sentiment analysis.
}
\keyword{datasets}
