% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ztils.R
\name{multicdf_plot}
\alias{multicdf_plot}
\title{multicdf_plot}
\usage{
multicdf_plot(
  var,
  seq_length = 50,
  distributions = "all",
  palette = "oslo",
  var_name = NULL
)
}
\arguments{
\item{var}{The variable to for which to plot CDFs}

\item{seq_length}{The number of points over which to fit x}

\item{distributions}{The distributions to fit x against}

\item{palette}{The color palette to use on the graph}

\item{var_name}{The variable name to use for x}
}
\value{
A plot showing the CDF of the selected variable against the
selected distributions over the selected sequence length
}
\description{
This function extends 'multiCDF_cont' and gets the cumulative distribution
functions (CDFs) for selected distributions against a continuous variable.
Possible distributions include any combination of "normal", "lognormal",
"gamma", "exponential", and "all" (which just uses all of the prior
distributions). It then plots this using 'ggplot2' and a 'scico' palette,
using var_name for the plot labeling, if specified. If not specified,
it will use var instead.
}
\examples{
multicdf_plot(iris$Sepal.Length)

multicdf_plot(iris$Sepal.Length,
              seq_length = 100,
              distributions = c("normal", "lognormal", "gamma"),
              palette = "bilbao",
              var_name = "Sepal Length (cm)"
              )
}
