#***********************************************************************************************************************************************
#*  
#*  (C) 2009     Andrzej Bk     Uniwersytet Ekonomiczny we Wrocawiu
#*  
#*  Funkcja do ksiki:
#*  "Statystyczna analiza danych z wykorzystaniem programu R", PWN, Warszawa 2009.
#*  
#*  Kod poniszy moe by modyfikowany, kopiowany i rozprowadzany na warunkach licencji GPL 2 (http://gnu.org.pl/text/licencja-gnu.html), 
#*  a w szczeglnoci pod warunkiem umieszczenia w zmodyfikowanym pliku widocznej informacji o dokonanych zmianach, wraz z dat ich dokonania. 
#*  
#***********************************************************************************************************************************************

# importance(ul, Lj) - funkcja obliczajca wanoci atrybutw
# ul - uytecznoci czstkowe (parametry) poziomw atrybutw (liczba parametrw = liczba zmiennych sztucznych + liczba atrybutw)
# Lj - liczba poziomw j-tego atrybutu (wektor Lj o dugoci rwnej liczbie atrybutw zawiera liczby poziomw kadego atrybutu)
# wywoanie - imp <- round(importance(ul, Lj)*100, 2)

importance <- function (ul, Lj)
{
   m <- length(Lj)               #liczba atrybutw
   p <- length(u)                #liczba parametrw (z wyrazem wolnym)
   imp <- vector("numeric", m)   #wektor wanoci atrybutw
   roz <- vector("numeric", m)   #wektor rozstpw
   i <- 0
   for(j in 1:m)
   {
      l <- Lj[j]                 #liczba poziomw j-tego atrybutu
      a <- vector("numeric", l)
      for(k in 1:l)
      {
         i <- i+1
         a[k] <- ul[i]
      }
      roz[j] <- max(a)-min(a)
   }
   rs <- sum(roz)
   for(j in 1:m) {imp[j] <- roz[j]/rs}
   return(imp)
}