#***********************************************************************************************************************************************
#*  
#*  (C) 2009     Eugeniusz Gatnar     Akademia Ekonomiczna w Katowicach
#*  
#*  Przykad do ksiki:
#*  "Statystyczna analiza danych z wykorzystaniem programu R", PWN, Warszawa 2009.
#*  
#*  Kod poniszy moe by modyfikowany, kopiowany i rozprowadzany na warunkach licencji GPL 2 (http://gnu.org.pl/text/licencja-gnu.html), 
#*  a w szczeglnoci pod warunkiem umieszczenia w zmodyfikowanym pliku widocznej informacji o dokonanych zmianach, wraz z dat ich dokonania. 
#*  
#***********************************************************************************************************************************************

library(mlbench)
library(rpart)
options(OutDec=",")
set.seed(114)
# podzial zbioru na cz uczc i testow
data(Vehicle)
l.obs <- nrow(Vehicle)
test <- sample(1:l.obs, round(l.obs/3), replace=FALSE)
veh.ucz <- Vehicle[-test,]
veh.test <- Vehicle[test,]
# budowa modelu
drzewo.veh <- rpart(Class~., data=veh.ucz, control=rpart.control(xval=100, cp=0))
tab.cp <- drzewo.veh$cptable
# poszukiwanie modelu optymalnego
model.opt <- which.min(tab.cp[,4])
cp.opt <- tab.cp[model.opt,1] 
drzewo.veh.p <- prune(drzewo.veh, cp=cp.opt)
# rysunek pokazujcy zaleno midzy wielkoci drzewa a bdem w sprawdzaniu krzyowym oraz bdem zastpienia
plot(tab.cp[,2]+1, tab.cp[,4], ylim=c(min(tab.cp[,3]),1), type="n", xlab="Wielko drzewa", ylab="Bd klasyfikacji")
lines(tab.cp[,2]+1, tab.cp[,4],lty=1)
lines(tab.cp[,2]+1, tab.cp[,3],lty=2)
points(tab.cp[,2]+1, tab.cp[,4],pch=21)
points(tab.cp[,2]+1, tab.cp[,3],pch=22)
legend("topright", legend=c("Bd w sprawdzaniu krzyowym","Bd zastpienia"), lty=1:2, pch=21:22)