#***********************************************************************************************************************************************
#*  
#*  (C) 2011    Ewa Witek     Uniwersytet Ekonomiczny w Katowicach
#*  
#*  Skrypt do ksiki:
#*  "Analiza danych jakociowych i symbolicznych z wykorzystaniem programu R", C.H. Beck, Warszawa 2011.
#*  
#*  Kod poniszy moe by modyfikowany, kopiowany i rozprowadzany na warunkach licencji GPL 2 (http://gnu.org.pl/text/licencja-gnu.html), 
#*  a w szczeglnoci pod warunkiem umieszczenia w zmodyfikowanym pliku widocznej informacji o dokonanych zmianach, wraz z dat ich dokonania. 
#*  
#***********************************************************************************************************************************************

set.seed(123)
library("flexmix")
data("bioChemists")
options(OutDec=",")
mix_wybor<-stepFlexmix(art~.,data=bioChemists,k=1:8,model=FLXMRglm(family="poisson"))
wybor_BIC<-getModel(mix_wybor,"BIC")
Model_mieszanek1<-FLXMRglmfix(family="poisson")
Model_mieszanek_parametry_1<-flexmix(art~fem+mar+kid5+phd+ment,data=bioChemists,cluster=posterior(wybor_BIC),model=Model_mieszanek1)
Model_mieszanek2<-FLXMRglmfix(family="poisson",fixed=~ment)
Model_mieszanek_parametry_2<-flexmix(art~fem+mar+kid5+phd,data=bioChemists,cluster=posterior(Model_mieszanek_parametry_1),model=Model_mieszanek2)
Model_mieszanek_4<-FLXMRglmfix(family="poisson",fixed=~ment+fem)
Model_mieszanek_parametry4<-flexmix(art~1,data=bioChemists,cluster=posterior(Model_mieszanek_parametry_2),model=Model_mieszanek_4)
plec<-predict(Model_mieszanek_parametry4,newdata=data.frame(kid5=0,mar=factor("Married",levels=c("Single","Married")),fem=c("Men","Women"),ment=mean(bioChemists$ment)))
matplot(0:12,sapply(unlist(plec),function(x) dpois(0:12,x)),type="b",lty=1,xlab="Liczba publikacji",ylab= "Prawdopodobiestwo",las=1)
legend("topright",paste("Klasa",rep(1:2,each=2),":",c("Meczyni","Kobiety")),lty=1,col=1:4,pch=paste(1:4),bty="n")