#***********************************************************************************************************************************************
#*  
#*  (C) 2011     Andrzej Dudek    Uniwersytet Ekonomiczny we Wrocawiu
#*  
#*  Skrypt do ksiki:
#*  "Analiza danych jakociowych i symbolicznych z wykorzystaniem programu R", C.H. BECK, Warszawa 2011.
#*  
#*  Kod poniszy moe by modyfikowany, kopiowany i rozprowadzany na warunkach licencji GPL 2 (http://gnu.org.pl/text/licencja-gnu.html), 
#*  a w szczeglnoci pod warunkiem umieszczenia w zmodyfikowanym pliku widocznej informacji o dokonanych zmianach, wraz z dat ich dokonania. 
#*  
#***********************************************************************************************************************************************

library(symbolicDA)
sdt<-parse.SO("samochody")
options(OutDec=",")
testSet<-26:33
dt<-decisionTree.SDA(sdt,"Typ_samochodu~.",testSet)
predicted<-dt$prediction
variables<-as.matrix(sdt$variables)
indivN<-as.matrix(sdt$indivN)
categorialVariable<-as.numeric(variables[variables[,"label"]=="Typ_samochodu","num"])
classes<-as.numeric(indivN[indivN[,"variable"]==categorialVariable,"value"])
actualClasses<-classes[testSet]
print(paste("Klasy rzeczywiste:",paste(predicted,collapse=",")))
print(paste("Przydzia do klas poprzez predykcj z wykorzystaniem drzewa klasyfikacyjnego:",paste(predicted,collapse=";")))
detailsListNom<-as.matrix(sdt$detailsListNom)
cat<-detailsListNom[detailsListNom[,"details_no"]==variables[categorialVariable,"details"],"label"]
print(paste("Przydzia do klas poprzez predykcj z wykorzystaniem drzewa klasyfikacyjnego kategorie:",paste(cat[predicted],collapse=";")))
print(paste("Bd klasyfikacji:",100*(1-sum(apply(cbind(actualClasses,predicted),1,function(x){if(x[1]==x[2]){1}else{0}}))/length(testSet)),"procent"))