\name{hsv}
\title{HSV Color Specification}
\usage{
hsv(h=1, s=1, v=1, gamma=1)
}
\alias{hsv}
\arguments{
\item{h,s,v}{numeric vectors of values in the range
  \code{[0,1]} for ``hue'', ``saturation'' and ``value''
  to be combined to form a vector of colors.  Values in shorter
  arguments are recycled.}
\item{gamma}{a ``gamma correction'', see ...}
}
\value{
This function creates a vector of ``colors'' corresponding to
the given values in HSV space.  The values returned by \code{hsv}
can be used with a \code{col=} specification in graphics functions or in
\code{par}.
}
\seealso{
\code{\link{rainbow}}, \code{\link{rgb}}, \code{\link{gray}}.
}
\examples{
hsv(.5,.5,.5)

## Look at gamma effect:
n <- 20;  y <- -sin(3*pi*((1:n)-1/2)/n)
op <- par(mfrow=c(3,2),mar=rep(1.5,4))
for(gamma in c(.4, .6, .8, 1, 1.2, 1.5))
  plot(y,axes=F,frame.plot=T,xlab="",ylab="",pch=21,cex=30,
       bg = rainbow(n, start=.85, end=.1, gamma = gamma),
       main = paste("Red tones;  gamma=",format(gamma)))
par(op)
}
\keyword{color}
\keyword{dplot}
