\name{length}
\title{Length of a Vector or List}
\usage{
length(x)
length(x) <- n
}
\alias{length}
\alias{length<-}
\description{
If \code{x} is (or can be coerced to) a vector or list, \code{length}
returns the length of \code{x}.
Otherwise, \code{length} returns \code{NA}.

The second form above can be used to reset
the length of a vector.
If a vector is shortened, extra values are discarded
and when a vector is lengthened, it is padded out to
its new length with \code{\link{NA}}s.
}
\examples{
length(diag(4))# = 16 (4 x 4)
length(options())# 12 or more..
length(y ~ x1 + x2 + x3)# 3
length(expression(x, {y <- x^2; y+2}, x^y)) # 3
}
\keyword{attribute}

