\name{kmeans}
\alias{kmeans}
\title{
K-Means Clustering
}
\usage{
kmeans(x, centers, iter.max=10)
}
\arguments{
\item{x}{
A data frame or matrix of data.
}
\item{centers}{
  Either the number of clusters or a set of initial cluster centers.
  If the first, a random set of rows in \code{x} are chosen as the initial
  centers.
}
\item{iter.max}{
The maximum number of iterations allowed.
}}
\description{
  The data given by \code{x} is clustered by the k-Means algorithm.
  This algorithm works by repeatedly moving all cluster centers
  to the mean of their Voronoi sets.

  The algorithm stops, if no cluster center has changed during the last
  iteration or the maximum number of iterations (given by
  \code{iter.max}) is reached.
}
\value{
A list with components:

\item{cluster}{
A vector of integers indicating the cluster to which each point is
allocated.
}
\item{centers}{
A matrix of cluster centres.
}
\item{withinss}{
The within-cluster sum of squares for each cluster.
}
\item{size}{
The number of points in each cluster
}}
\references{
Hartigan,  J.A. and Wong, M.A. (1979).
A K-means clustering algorithm.
Applied Statistics 
\bold{28}, 100-108.
}
\examples{
# a 2-dimensional example
x<-rbind(matrix(rnorm(100,sd=0.3),ncol=2),
         matrix(rnorm(100,mean=1,sd=0.3),ncol=2))
cl<-kmeans(x,2,20)
plot(x,col=cl$cluster)
points(cl$centers,col=1:2,pch=8)
}
\keyword{multivariate}
\keyword{cluster}
% Converted by Sd2Rd version 0.2-a5.
