\name{time}
\title{Sampling Times of Time Series}
\usage{
time(x, offset=0, \dots)
cycle(x, \dots)
frequency(x, \dots)
deltat(x, \dots)
}
\alias{time}
\alias{cycle}
\alias{frequency}
\alias{deltat}
\alias{time.default}
\alias{time.ts}
\alias{cycle.default}
\alias{cycle.ts}
\alias{frequency.default}
\alias{deltat.default}
\arguments{
    \item{x}{a univariate or multivariate time-series, or a vector or matrix.}
    \item{offset}{can be used to indicate when sampling took place
	in the time unit. \code{0} (the default) indicates the start
	of the unit, \code{0.5} the middle and \code{1} the end of
	the interval.}
    \item{\dots}{extra arguments for future methods.}
}
\description{
  \code{time} creates the vector of times at which a time series was sampled.

  \code{cycle} gives the positions in the cycle of each observation.

  \code{frequency} returns the number of samples per unit time and
  \code{deltat} the time interval between observations (see
  \code{\link{ts}}).
}
\details{
    These are all generic functions, which will use the
    \code{\link{tsp}} attribute of \code{x} if it exists. \code{time}
    and \code{cycle} have methods for class \code{\link{ts}} that coerce
    the result to that class.
}
\seealso{
    \code{\link{ts}}, \code{\link{start}}, \code{\link{tsp}},
    \code{\link{window}}.

    \code{\link{date}} for clock time, \code{\link{system.time}}
    for CPU usage.
}
\examples{
data(presidents)
cycle(presidents)
# a simple series plot: c() makes the x and y arguments into vectors
plot(c(time(presidents)), c(presidents), type="l")
}
\keyword{ts}
