\name{xfig}
\title{XFig Graphics Device}
\usage{
xfig(file = "Rplots.fig", \dots)
}
\alias{xfig}
\arguments{
\item{file}{a character string giving the name of the file.  If it is
  \code{""}, the output is piped to the command given by
  the argument \code{command}.  For use with \code{onefile=FALSE} give a
  \code{printf} format such as \code{"Rplot%d.fig"} (the default in that
  case).
}
\item{\dots}{further options for \code{xfig()}.}
\item{paper}{the size of paper in the printer.  The choices are
  \code{"A4"}, \code{"Letter"} amd \code{"Legal"}
  (and these can be lowercase). A further choice is
  \code{"default"}, which is the default.  If this is selected, the
  papersize is taken from the option \code{"papersize"}
  if that is set and to \code{"A4"} if it is unset or empty.}
\item{horizontal}{the orientation of the printed image, a
    logical. Defaults to true, that is landscape orientation.}
\item{width, height}{the width and height of the graphics region in inches.
  The default is to use the entire page less a 0.25 inch border.}
\item{family}{the font family to be used.
  This must be one of \code{"AvantGarde"},
  \code{"Bookman"}, \code{"Courier"}, \code{"Helvetica"},
  \code{"Helvetica-Narrow"}, \code{"NewCenturySchoolbook"},
  \code{"Palatino"} or \code{"Times"}.}
\item{pointsize}{the default point size to be used.}
\item{bg}{the default background color to be used.}
\item{fg}{the default foreground color to be used.}
\item{onefile}{logical: if true (the default) allow multiple figures
  in one file. If false, assume only one page per file and generate a
  file number containing the page number.}
\item{pagecentre}{logical: should the device region be centred on the page:
  defaults to true.}
}
%%>>> REAL DOC in SOURCE:    ../../../main/devices.c  &   ../../../unix/devPS.c
\description{
  \code{xfig} starts the graphics device driver for producing
  XFig (version 3.2) graphics.

  The auxiliary function \code{ps.options} can be used to set and view
  (if called without arguments)
  default values for the arguments to \code{xfig} and \code{postscript}.
}

\details{
  Although \code{xfig} can produce multiple plots in one file, the XFig
  format does not say how to separate or view them. So
  \code{onefile=FALSE} is the default.
}
\note{
  One some line textures (\code{0 <= lty > 4}) are used. Eventually this
  will be partially remedied, but the XFig file format does not allow as
  general line textures as the \R model.  Unimplemented line textures
  are displayed as \emph{dash-double-dotted}.

  There is a limit of 512 colours (plus white and black) per file.
}
\seealso{
  \code{\link{Devices}}, \code{postscript}.
}
\keyword{device}
