% File src/library/tools/man/buildVignettes.Rd
% Part of the R package, http://www.R-project.org
% Copyright 1995-2011 R Core Team
% Distributed under GPL 2 or later

\name{buildVignettes}
\alias{buildVignettes}
\alias{pkgVignettes}
\title{List and Build Package Vignettes}
\description{
  Run \code{\link{Sweave}} and \code{\link{texi2dvi}} on all vignettes
  of a package.
}
\usage{
buildVignettes(package, dir, lib.loc = NULL, quiet = TRUE, clean = TRUE)

pkgVignettes(package, dir, lib.loc = NULL)
}
\arguments{
  \item{package}{a character string naming an installed package.  If
    given, Sweave files are searched in subdirectory \file{doc}.}
  \item{dir}{a character string specifying the path to a package's root
    source directory.  This subdirectory \file{vignettes} (or if it
    does not exist \file{inst/doc}) is searched for Sweave files.}
  \item{lib.loc}{a character vector of directory names of \R libraries,
    or \code{NULL}.  The default value of \code{NULL} corresponds to all
    libraries currently known.  The specified library trees are used to
    search for \code{package}.}
  \item{quiet}{logical. Run \code{\link{Sweave}} and
    \code{\link{texi2pdf}} in quiet mode.}
  \item{clean}{Remove all files generated by the build, even if there
    were copies there before.}
}
\details{
  \code{buildVignettes} is used by \code{R CMD build} and \code{R CMD
    check} to (re-)build vignette PDFs on the Sweave sources.
}
\value{
  \code{buildVignettes} is called for its side effect of creating the
  PDF versions of all vignettes.
  
  \code{pkgVignettes} returns an object of class \code{"pkgVignettes"}
  if a vignette directory is found, otherwise \code{NULL}.
}
\keyword{utilities}
\keyword{documentation}
