% File src/library/grid/man/grid.function.Rd
% Part of the R package, http://www.R-project.org
% Copyright 1995-2007 R Core Team
% Distributed under GPL 2 or later

\name{grid.function}
\alias{grid.function}
\alias{functionGrob}
\alias{grid.abline}
\title{Draw a curve representing a function}
\description{
  Draw a curve representing a function.
}
\usage{
grid.function(...)
functionGrob(f, n = 101, range = "x", units = "native",
             name = NULL, gp=gpar(), vp = NULL)

grid.abline(intercept, slope, ...) 
}
\arguments{
  \item{f}{ A function that must take a single argument
    and return a list with two numeric components named \code{x} and
    \code{y}.}
  \item{n}{ The number values that will be generated as input
    to the function \code{f}.}
  \item{range}{ Either \code{"x"}, \code{"y"}, or a numeric vector.
    See the \sQuote{Details} section.}
  \item{units}{A string indicating the units to use
    for the \code{x} and \code{y} values generated by the function.}
  \item{intercept}{ Numeric.}
  \item{slope}{ Numeric. }
  \item{\dots}{ Arguments passed to \code{grid.function()}}
  \item{name}{ A character identifier. }
  \item{gp}{An object of class \code{gpar}, typically the output
    from a call to the function \code{gpar}.  This is basically
    a list of graphical parameter settings.}
  \item{vp}{A Grid viewport object (or NULL).}
}
\details{
  \code{n} values are generated and passed to the function \code{f}
  and a series of lines are
  drawn through the resulting \code{x} and \code{y} values.

  The generation of the \code{n} values depends on the value of 
  \code{range}.  In the default case, \code{dim} is
  \code{"x"}, which means that a set
  of \code{x} values are generated covering the range of the current
  viewport scale in the x-dimension.  If \code{dim} is \code{"y"}
  then values are generated from the current y-scale instead.
  If \code{range} is a numeric vector, then values are generated
  from that range.

  \code{grid.abline()} provides a simple front-end for a straight
  line parameterized by \code{intercept} and \code{slope}.
}
\value{
  A functiongrob grob.
}
\author{Paul Murrell}
\seealso{
  \link{Grid},
  \code{\link{viewport}}
}
\examples{
    # abline
    # NOTE: in ROOT viewport on screen, (0, 0) at top-left
    #       and "native" is pixels!
    grid.function(function(x) list(x=x, y=0 + 1*x))
    # a more "normal" viewport with default normalized "native" coords
    grid.newpage()
    pushViewport(viewport())
    grid.function(function(x) list(x=x, y=0 + 1*x))
    # slightly simpler
    grid.newpage()
    pushViewport(viewport())
    grid.abline()
    # sine curve
    grid.newpage()
    pushViewport(viewport(xscale=c(0, 2*pi), yscale=c(-1, 1)))
    grid.function(function(x) list(x=x, y=sin(x)))
    # constrained sine curve
    grid.newpage()
    pushViewport(viewport(xscale=c(0, 2*pi), yscale=c(-1, 1)))
    grid.function(function(x) list(x=x, y=sin(x)),
                  range=0:1)
    # inverse sine curve
    grid.newpage()
    pushViewport(viewport(xscale=c(-1, 1), yscale=c(0, 2*pi)))
    grid.function(function(y) list(x=sin(y), y=y),
                  range="y")
    # parametric function
    grid.newpage()
    pushViewport(viewport(xscale=c(-1, 1), yscale=c(-1, 1)))
    grid.function(function(t) list(x=cos(t), y=sin(t)),
                  range=c(0, 9*pi/5))
    # physical abline
    grid.newpage()
    grid.function(function(x) list(x=x, y=0 + 1*x),
                  units="in")
}
\keyword{dplot}
