#  File src/library/stats4/R/BIC.R
#  Part of the R package, http://www.R-project.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  A copy of the GNU General Public License is available at
#  http://www.r-project.org/Licenses/

## we need this stats4::logLik to avoid stats namespace issues
setGeneric("AIC", useAsDefault=function(object, ..., k = 2)
           stats::AIC(stats4::logLik(object),  ..., k = k))

setGeneric("BIC", function(object, ...) standardGeneric("BIC"))

setMethod("BIC", signature(object="logLik"),
function(object, ...){
    -2 * c(object) + attr(object, "df") * log(attr(object, "nobs"))
})

setMethod("BIC", signature(object="ANY"),
function(object, ...){
    BIC(object=logLik(object, ...))
})
