\name{smooth.construct.tensor.smooth.spec}
\alias{smooth.construct.tensor.smooth.spec}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Tensor product smoothing constructor}

\description{A special \code{smooth.construct} method function for creating tensor product smooths from any
combination of single penalty marginal smooths.

}

\usage{
\method{smooth.construct}{tensor.smooth.spec}(object, data, knots)
}

\arguments{ 
\item{object}{a smooth specification object of class \code{tensor.smooth.spec}, 
              usually generated by a term like \code{te(x,z)} in a \code{\link{gam}} model formula}

\item{data}{a list containing just the data (including any \code{by} variable) required by this term, 
            with names corresponding to \code{object$term} (and \code{object$by}). The \code{by} variable 
            is the last element.} 

\item{knots}{a list containing any knots supplied for basis setup --- in same order and with same names as \code{data}. 
             Can be \code{NULL}. See details for further information.}

}

\value{ An object of class \code{"tensor.smooth"}. See \code{\link{smooth.construct}}, 
for the elements that this object will contain.
}

\details{Tensor product smooths are smooths of several variables which allow the degree of smoothing to be different with respect
to different variables. They are useful as smooth interaction terms, as they are invariant to linear rescaling of the covariates,
which means, for example, that they are insensitive to the measurement units of the different covariates. They are also useful 
whenever isotropic smoothing is inappropriate. See \code{\link{te}}, \code{\link{smooth.construct}} and 
\code{\link{smooth.terms}}.
}

\references{

Wood, S.N. (2006) Low rank scale invariant tensor product smooths for
generalized additive mixed models. Biometrics 62(4):1025-1036

}

\author{ Simon N. Wood \email{simon.wood@r-project.org}}

\seealso{\code{\link{cSplineDes}}}

\examples{
## see ?gam

}
\keyword{models} \keyword{regression}%-- one or more ..


