% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{check_assign_na}
\alias{check_assign_na}
\title{Check an output field and assign NA when input variables all have NAs}
\usage{
check_assign_na(data, output, input, allow_missingness = TRUE)
}
\arguments{
\item{data}{tbl. Data frame containing the columns to be summarized.}

\item{output}{character of length 1. The name of the first variable/column.}

\item{input}{character. The name of the second variable/column.}

\item{allow_missingness}{logical. Default set to TRUE. If TRUE, \code{output}
field is set to \code{NA} only when ALL the fields in \code{input} have missingness.
If FALSE, \code{output} is set to \code{NA} when ANY of the \code{input} fields
have missingness.}
}
\value{
tbl. The input data frame with the \code{output} column modified.
}
\description{
Checks the specified output column in a data frame and assigns NA to its value depending on the missingness of a set of input columns.
If \code{allow_missingness = TRUE}, the output column is set to NA only when \emph{all} the specified input columns are NA.
If \code{allow_missingness = FALSE}, the output column is set to NA when \emph{any} of the input columns are NA.
This function is useful for propagating missingness from input variables to a derived output.
}
\examples{
# Example data
dat <- tibble::tibble(
  a = c(1, NA, 3),
  b = c(NA, NA, 2),
  c = c(1, 2, 3),
  out = c(10, 11, 12)
)

# Assign NA to out when all of a and b are NA
check_assign_na(
  dat,
  output = "out", input = c("a", "b"), allow_missingness = TRUE
)

# Assign NA to out when any of a and b are NA
check_assign_na(
  dat,
  output = "out", input = c("a", "b"), allow_missingness = FALSE
)

}
