% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ACSN_Enrichment.R
\name{multisample_enrichment}
\alias{multisample_enrichment}
\title{Automated gene set analysis for multiple sets}
\usage{
multisample_enrichment(Genes_by_sample = NULL, maps = ACSNMineR::ACSN_maps,
  correction_multitest = "BH", statistical_test = "fisher",
  min_module_size = 5, universe = "map_defined", threshold = 0.05,
  cohort_threshold = TRUE, alternative = "greater")
}
\arguments{
\item{Genes_by_sample}{List of character vectors. Each list element name should be a sample name,
and each character vector the set of genes to test for the sample.}

\item{maps}{list of maps generated by format_from_gmt. Default: tests on all acsn maps}

\item{correction_multitest}{either FALSE, "bonferroni", "holm", "hochberg", "hommel", "BH", "fdr" (identical to BH), or "BY"}

\item{statistical_test}{one of "fisher", "hypergeom"}

\item{min_module_size}{will remove from the analysis all modules which are (strictly) smaller than threshold}

\item{universe}{Universe on which the statistical analysis should be performed. Can be either "HUGO","ACSN"
,"map_defined", or a character vector of genes.}

\item{threshold}{maximal p-value (corrected if correction is enabled) that will be displayed}

\item{cohort_threshold}{if TRUE modules will be kept in all samples if at least one sample
has p-value lower than threshold, otherwise the threshold is applied for each sample independently.}

\item{alternative}{One of "greater", "less", "both", or "two.sided" (only for fisher test).
Greater will check for enrichment, less will check for depletion, and both will look for both.}
}
\description{
Automated gene set analysis for multiple sets
}
\examples{
multisample_enrichment(Genes_by_sample = list(set1 = genes_test[-1],set2=genes_test[-2]),
maps = list(cellcycle = ACSNMineR::ACSN_maps$CellCycle),
min_module_size = 10,
universe = "ACSN")
}

