% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_rv_density.R
\name{dmvnorm0}
\alias{dmvnorm0}
\title{The density of the multivariate normal distribution}
\usage{
dmvnorm0(x, mean, sigma, log = FALSE)
}
\arguments{
\item{x}{vector or matrix of quantiles. If x is a matrix, each row is taken to be a quantile.}

\item{mean}{numeric vector; the mean vector.}

\item{sigma}{numeric matrix; the covariance matrix.}

\item{log}{logical; if TRUE, returns the log value.}
}
\description{
The density of the multivariate normal distribution
}
\examples{
n <- 10
d <- 2
sigma <- crossprod(randn(d, d))
x <- rmvnorm0(n, mean = numeric(d), sigma = sigma)
dmvnorm0(x, mean = numeric(d), sigma = sigma)

}
