% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Amatrix.R
\name{Amatrix}
\alias{Amatrix}
\title{Construction of Relationship Matrix A}
\usage{
Amatrix(data = NULL, ploidy = 2, w = 0, verify = TRUE,
  dominance = FALSE, slater = FALSE, ...)
}
\arguments{
\item{data}{pedigree data name (3-column way format). Unknown value should be equal 0.}

\item{ploidy}{an even number (default=2).}

\item{w}{proportion of parental gametas IBD due to double reduction (default=0), only if ploidy=4.}

\item{verify}{verifies pedigree file for conflictuos entries (default=TRUE).}

\item{dominance}{if true, returns the dominance relationship matrix}

\item{slater}{if true, returns the additive autotetraploid relationship matrix as Slater (2013)}

\item{...}{arguments to be passed to datatreat()}
}
\value{
Matrix with the Relationship between the individuals.
}
\description{
Creates a additive relationship matrix A from a pedigree data in a 3-column way format based on ploidy level (an even number) and, if ploidy equals 4, based on proportion of parental gametes that are IBD (Identical by Descent) due to double reduction. Returns a dominance relationship matrix if dominance true (ploidy 2 only). Autopolyploid matrices based on Kerr (2012). Construction is based on the Henderson's recursive method described in Mrode (2005).
}
\examples{
data(ped.mrode)
#Build Amatrix diploid (no double reduction proportion)
Amatrix(data=ped.mrode,ploidy=2)
#Build Amatrix autotetraploidy (double reduction proportion=0.1)
Amatrix(data=ped.mrode,ploidy=4,w=0.1)
#' #Build Amatrix autooctaploid (no double reduction proportion)
Amatrix(data=ped.mrode,ploidy=8)

}
\references{
\emph{Chapter 2: Genetic Covariance Between Relatives and Chapter 9: Non-additive Animal Models in Mrode, R. A., and Thompson, R. Linear models for the prediction of animal breeding values. Cabi, 2005.}

\emph{Slater, A. T., Wilson, G. M., Cogan, N. O., Forster, J. W., & Hayes, B. J. (2013). Improving the analysis of low heritability complex traits for enhanced genetic gain in potato. Theoretical and Applied Genetics, 1-12.}

\emph{Kerr, Richard J., et al. "Use of the numerator relationship matrix in genetic analysis of autopolyploid species." Theoretical and Applied Genetics 124.7 (2012): 1271-1282.}
}
\author{
Rodrigo R Amadeu, \email{rramadeu@ufl.edu}
}
