% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/quantiles.R
\name{wkmQuantile}
\alias{wkmQuantile}
\title{wkmQuantile}
\usage{
wkmQuantile(tau, formula, data, conf.level = 0.95, null.value = NULL,
  start = 0)
}
\arguments{
\item{tau}{number between 0 and 1 specifiying the quantile to estimate}

\item{formula}{an object of class '"formula"' specifying the conditional survival model}

\item{data}{data frame containing the variables in formula}

\item{conf.level}{confidence level (or NULL if no confidence interval should be calculated)}

\item{null.value}{true value of quantile or NULL if no p-value should be calculated}

\item{start}{time of interim analysis (estimation of response rates is based only on data accruing after time 'start')}
}
\value{
An object of class '"survQuantile"'
}
\description{
Estimate arbitrary quantiles of a survival distribution based on the (weighted) Kaplan-Meier
}
\examples{
T <- c(rexp(100, 1), rexp(100, 2))
C <- c(rexp(100, 1), rexp(100, 2))
Y <- pmin(T, C)
D <- T <= C
Z <- rep(c(0,1), c(100, 100))
wkmQuantile(0.5, Surv(Y, D) ~ strata(Z), data.frame(Y=Y, D=D, Z=Z))
}
\references{
brookmeyer_confidence_1982
}

