% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_assertions.R
\name{check_assertions}
\alias{check_assertions}
\title{Check assertions in occurrences object}
\usage{
check_assertions(x)
}
\arguments{
\item{x}{list: an object returned from \code{\link{occurrences}}}
}
\value{
A dataframe of assertions column names, descriptions and categories/error codes. If no assertions are in the dataset, NULL is returned.
}
\description{
This provides a data.frame detailing the assertions that are found in a dataset returned from \code{\link{occurrences}}.
}
\examples{
\dontrun{
 ##download species data with all possible assertions

 x <- occurrences(taxon="golden bowerbird", download_reason_id=10, qa=ala_fields("assertions")$name)

 asserts <- check_assertions(x)
 ## this is a data.frame of assertions, their description and column names

 ## list the descriptions of all (current) assertions
 asserts$description

 tmp <- x$data[, names(x$data) \%in\% asserts$name] ## assertion columns from data
 which(colSums(tmp)>0) ## discard those not seen in the data
}
}
\references{
\url{http://api.ala.org.au/}, \samp{http://biocache.ala.org.au/ws/assertions/codes}
}
