% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcs.R, R/plots.R
\name{Comparison plots}
\alias{Comparison plots}
\alias{pitable}
\alias{plot_majuro}
\alias{quantile_plot}
\alias{myboxplot}
\alias{myradar}
\alias{hcr_plot}
\alias{hcr_histo_plot}
\title{pitable}
\usage{
pitable(dat, percentile_range = c(20, 80))

plot_majuro(dat, percentile_range = c(20, 80), hcr_choices, stock_params)

quantile_plot(dat, hcr_choices, wormdat = NULL, alpha20_80 = 0.6,
  linetype_worm = 1, percentile_range = c(20, 80),
  colour_worm = "black", size_worm = 0.3, add_start_line = TRUE,
  time_period_lines = TRUE, short_term = 2016:2024,
  medium_term = 2025:2033, long_term = 2034:2042,
  last_plot_year = 2042, show_spaghetti = FALSE)

myboxplot(dat, hcr_choices, plot_type = "median_bar")

myradar(dat, hcr_choices, scaling = "scale", polysize = 2)

hcr_plot(hcr_choices, hcr_shape, hcr_points, lrp, trp, blacklinesize = 4,
  linesize = 3, pointsize = 4.2, stroke = 3)

hcr_histo_plot(hcr_choices, histodat)
}
\arguments{
\item{dat}{The data.frame with the data to be plotted.}

\item{percentile_range}{A vector of length with minimum and maximum percentile range to plot.}

\item{hcr_choices}{The names of the HCRs to plot.}

\item{stock_params}{A vector of life history and stochasticy parameters.}

\item{wormdat}{Data set of the spaghetti (worms).}

\item{alpha20_80}{Alpha of the ribbons.}

\item{linetype_worm}{Line type of the spaghetti.}

\item{colour_worm}{Colour of the spaghetti.}

\item{size_worm}{Thickness of the spaghetti.}

\item{add_start_line}{Add a line to the start of the projection (TRUE / FALSE).}

\item{time_period_lines}{Add a lines to show the time periods (TRUE / FALSE).}

\item{short_term}{Year range for the short-term.}

\item{medium_term}{Year range for the medium-term.}

\item{long_term}{Year range for the long-term.}

\item{last_plot_year}{Last year to plot.}

\item{show_spaghetti}{Show the spaghetti (worms) (TRUE / FALSE).}

\item{plot_type}{Either median_bar or box.}

\item{scaling}{Either scale or rank.}

\item{polysize}{The thickness of the radar.}

\item{hcr_shape}{The shape parameters of each HCR,}

\item{hcr_points}{Optionally show the bits of the HCR that triggered (currently not used).}

\item{lrp}{The limit reference point.}

\item{trp}{The target reference point.}

\item{blacklinesize}{Size of the underlying black lines.}

\item{linesize}{Size of the coloured lines.}

\item{pointsize}{Size of the points (currently not used).}

\item{stroke}{Mmmmm, stroking.}

\item{histodat}{Data for the histograms.}
}
\value{
A data.frame to be shown as a table.

A ggplot2 plot object.

A ggplot2 plot object.

A ggplot2 plot object.

A ggplot2 plot object.

A ggplot2 plot object.

A ggplot2 plot object.
}
\description{
pitable() is not a plot but a table comparing PIs across HCRs and periods. Only pass in 1 time period at a time.

plot_majuro() plots a Majuro plot.

quantile_plot() plots times series of indicators for each HCR.

myboxplot() plots box plots or bar charts of the median values of the indicators for each HCR.

myradar() plots a radar chart in each time period, scaled either by the maximum or by ranking.

hcrplot() plots the shape of each HCR.

hcr_histo_plot() plots histograms of the HCR outputs in each time period.
}
\examples{


# Set up all the bits for a projection - should be done inside a Shiny app
# Managment procedure bits - should come from Shiny app inputs
input_mp <- list(
  blim_belbow = c(0.2, 0.5),
  cmin_cmax = c(10, 140), 
  constant_catch_level = 50,
  constant_effort_level = 1,
  emin_emax = c(0.1, 0.5),
  hcr_type = "threshold_catch")
mp_params <- mp_params_switcheroo(input_mp)

# Stochasticity bits - should come from Shiny app inputs
input_stoch <- list(
  biol_est_bias = 0,
  biol_est_sigma = 0.2,
  biol_prod_sigma = 0.2, 
  show_var <- TRUE)
stoch_params <- set_stoch_params(input_stoch)

# Life history bits - should come from Shiny app inputs
input_lh <- list(
  stock_history = "fully",
  stock_lh = "medium")
lh_params <- get_lh_params(input_lh)

# Stitch together and make other parameters - should be inside an Shiny app 
stock_params <- c(stoch_params, lh_params)
app_params <- list(initial_year = 2009, last_historical_timestep = 10)

# Make the null stock and fill it up
# In a Shiny app use the create_stock() function but cannot do here so make an equivalent object
stock <- list(biomass = NULL, hcr_ip = NULL, hcr_op = NULL, effort = NULL, catch = NULL)
stock <- reset_stock(stock = stock, stock_params = stock_params, mp_params = mp_params,
  app_params = app_params, initial_biomass = stock_params$b0, nyears = 40, niters = 10)
# Finally project over the timesteps
stock <- project(stock, timesteps = c(11,40), stock_params = stock_params,
  mp_params = mp_params, app_params = app_params)
# Get the summaries
pisums <- get_summaries(stock=stock, stock_params=stock_params, app_params=app_params,
  quantiles=c(0.01,0.05,0.20,0.5,0.80,0.95,0.99))
# Add an HCR name (done inside Shiny app)
pisums$worms$hcrref <- "HCR 1"
pisums$yearqs$hcrref <- "HCR 1"
pisums$periodqs$hcrref <- "HCR 1"

# Majuro plot
plot_majuro(dat=pisums$yearqs, hcr_choices="HCR 1", stock_params=stock_params)
# Time series quantile plot
quantile_plot(dat=pisums$yearqs, hcr_choices="HCR 1", wormdat=pisums$worms)
# Bar and box plots
myboxplot(dat=pisums$periodqs, hcr_choices="HCR 1", plot_type="median_bar")
myboxplot(dat=pisums$periodqs, hcr_choices="HCR 1", plot_type="box")
# Radar plot
myradar(dat=pisums$periodqs, hcr_choices="HCR 1", scaling="scale", polysize=2)
# Table of PIs. Only pass in 1 time period
pitable(dat=subset(pisums$periodqs, period=="Long"))
}
