% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mo_property.R
\name{mo_property}
\alias{mo_property}
\alias{mo_fullname}
\alias{mo_shortname}
\alias{mo_subspecies}
\alias{mo_species}
\alias{mo_genus}
\alias{mo_family}
\alias{mo_order}
\alias{mo_class}
\alias{mo_phylum}
\alias{mo_subkingdom}
\alias{mo_kingdom}
\alias{mo_type}
\alias{mo_gramstain}
\alias{mo_TSN}
\alias{mo_ref}
\alias{mo_authors}
\alias{mo_year}
\alias{mo_taxonomy}
\title{Property of a microorganism}
\usage{
mo_fullname(x, language = get_locale(), ...)

mo_shortname(x, language = get_locale(), ...)

mo_subspecies(x, language = get_locale(), ...)

mo_species(x, language = get_locale(), ...)

mo_genus(x, language = get_locale(), ...)

mo_family(x, ...)

mo_order(x, ...)

mo_class(x, ...)

mo_phylum(x, ...)

mo_subkingdom(x, ...)

mo_kingdom(x, ...)

mo_type(x, language = get_locale(), ...)

mo_gramstain(x, language = get_locale(), ...)

mo_TSN(x, ...)

mo_ref(x, ...)

mo_authors(x, ...)

mo_year(x, ...)

mo_taxonomy(x, ...)

mo_property(x, property = "fullname", language = get_locale(), ...)
}
\arguments{
\item{x}{any (vector of) text that can be coerced to a valid microorganism code with \code{\link{as.mo}}}

\item{language}{language of the returned text, defaults to system language (see \code{\link{get_locale}}) and can also be set with \code{\link{getOption}("AMR_locale")}. Use \code{language = NULL} or \code{language = ""} to prevent translation.}

\item{...}{other parameters passed on to \code{\link{as.mo}}}

\item{property}{one of the column names of one of the \code{\link{microorganisms}} data set or \code{"shortname"}}
}
\value{
\itemize{
  \item{An \code{integer} in case of \code{mo_TSN} and \code{mo_year}}
  \item{A \code{list} in case of \code{mo_taxonomy}}
  \item{A \code{character} in all other cases}
}
}
\description{
Use these functions to return a specific property of a microorganism from the \code{\link{microorganisms}} data set. All input values will be evaluated internally with \code{\link{as.mo}}.
}
\details{
All functions will return the most recently known taxonomic property according to ITIS, except for \code{mo_ref}, \code{mo_authors} and \code{mo_year}. This leads to the following results:
\itemize{
  \item{\code{mo_fullname("Chlamydia psittaci")} will return \code{"Chlamydophila psittaci"} (with a warning about the renaming)}
  \item{\code{mo_ref("Chlamydia psittaci")} will return \code{"Page, 1968"} (with a warning about the renaming)}
  \item{\code{mo_ref("Chlamydophila psittaci")} will return \code{"Everett et al., 1999"} (without a warning)}
}
}
\section{Supported languages}{

Supported languages are \code{"en"} (English), \code{"de"} (German), \code{"nl"} (Dutch), \code{"es"} (Spanish), \code{"it"} (Italian), \code{"fr"} (French), and \code{"pt"} (Portuguese).
}

\section{ITIS}{

\if{html}{\figure{itis_logo.jpg}{options: height=60px style=margin-bottom:5px} \cr}
This package contains the \strong{complete microbial taxonomic data} (with all eight taxonomic ranks - from kingdom to subspecies) from the publicly available Integrated Taxonomic Information System (ITIS, \url{https://www.itis.gov}).

All (sub)species from \strong{the taxonomic kingdoms Bacteria, Fungi and Protozoa are included in this package}, as well as all previously accepted names known to ITIS. Furthermore, the responsible authors and year of publication are available. This allows users to use authoritative taxonomic information for their data analysis on any microorganism, not only human pathogens. It also helps to quickly determine the Gram stain of bacteria, since all bacteria are classified into subkingdom Negibacteria or Posibacteria.

ITIS is a partnership of U.S., Canadian, and Mexican agencies and taxonomic specialists [3].
}

\section{Source}{

[1] Becker K \emph{et al.} \strong{Coagulase-Negative Staphylococci}. 2014. Clin Microbiol Rev. 27(4): 870–926. \url{https://dx.doi.org/10.1128/CMR.00109-13}

[2] Lancefield RC \strong{A serological differentiation of human and other groups of hemolytic streptococci}. 1933. J Exp Med. 57(4): 571–95. \url{https://dx.doi.org/10.1084/jem.57.4.571}

[3] Integrated Taxonomic Information System (ITIS). Retrieved September 2018. \url{http://www.itis.gov}
}

\examples{
# All properties of Escherichia coli
## taxonomic properties
mo_kingdom("E. coli")         # "Bacteria"
mo_subkingdom("E. coli")      # "Negibacteria"
mo_phylum("E. coli")          # "Proteobacteria"
mo_class("E. coli")           # "Gammaproteobacteria"
mo_order("E. coli")           # "Enterobacteriales"
mo_family("E. coli")          # "Enterobacteriaceae"
mo_genus("E. coli")           # "Escherichia"
mo_species("E. coli")         # "coli"
mo_subspecies("E. coli")      # NA
mo_TSN("E. coli")             # 285 (Taxonomic Serial Number)

## colloquial properties
mo_fullname("E. coli")        # "Escherichia coli"
mo_shortname("E. coli")       # "E. coli"

## other properties
mo_gramstain("E. coli")       # "Gram negative"
mo_type("E. coli")            # "Bacteria" (equal to kingdom)

## scientific reference
mo_ref("E. coli")             # "Castellani and Chalmers, 1919"
mo_authors("E. coli")         # "Castellani and Chalmers"
mo_year("E. coli")            # 1919


# Abbreviations known in the field
mo_genus("MRSA")              # "Staphylococcus"
mo_species("MRSA")            # "aureus"
mo_shortname("MRSA")          # "S. aureus"
mo_gramstain("MRSA")          # "Gram positive"

mo_genus("VISA")              # "Staphylococcus"
mo_species("VISA")            # "aureus"


# Known subspecies
mo_genus("doylei")            # "Campylobacter"
mo_species("doylei")          # "jejuni"
mo_fullname("doylei")         # "Campylobacter jejuni doylei"

mo_fullname("K. pneu rh")     # "Klebsiella pneumoniae rhinoscleromatis"
mo_shortname("K. pneu rh")    # "K. pneumoniae"


# Becker classification, see ?as.mo
mo_fullname("S. epi")                     # "Staphylococcus epidermidis"
mo_fullname("S. epi", Becker = TRUE)      # "Coagulase Negative Staphylococcus (CoNS)"
mo_shortname("S. epi")                    # "S. epidermidis"
mo_shortname("S. epi", Becker = TRUE)     # "CoNS"

# Lancefield classification, see ?as.mo
mo_fullname("S. pyo")                     # "Streptococcus pyogenes"
mo_fullname("S. pyo", Lancefield = TRUE)  # "Streptococcus group A"
mo_shortname("S. pyo")                    # "S. pyogenes"
mo_shortname("S. pyo", Lancefield = TRUE) # "GAS" ('Group A streptococci')


# Language support for German, Dutch, Spanish, Portuguese, Italian and French
mo_gramstain("E. coli", language = "de")  # "Gramnegativ"
mo_gramstain("E. coli", language = "nl")  # "Gram-negatief"
mo_gramstain("E. coli", language = "es")  # "Gram negativo"

# mo_type is equal to mo_kingdom, but mo_kingdom will remain official
mo_kingdom("E. coli")                     # "Bacteria" on a German system
mo_type("E. coli")                        # "Bakterien" on a German system
mo_type("E. coli")                        # "Bacteria" on an English system

mo_fullname("S. pyogenes",
            Lancefield = TRUE,
            language = "de")              # "Streptococcus Gruppe A"
mo_fullname("S. pyogenes",
            Lancefield = TRUE,
            language = "nl")              # "Streptococcus groep A"


# Get a list with the complete taxonomy (subkingdom to subspecies)
mo_taxonomy("E. coli")
}
\seealso{
\code{\link{microorganisms}}
}
