% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perm.ds.focal.R
\name{perm.ds.focal}
\alias{perm.ds.focal}
\title{Data stream permutation for focal sampling data .}
\usage{
perm.ds.focal(
  df,
  focal,
  ctrl = NULL,
  alters,
  nperm,
  progress = T,
  index = "sri"
)
}
\arguments{
\item{df}{a data frame.}

\item{focal}{an integer indicating the column of the focal.}

\item{ctrl}{a numeric vector indicating the control factors.}

\item{alters}{an integer indicating the column of focal's alters.}

\item{nperm}{an integer indicating the number of permutations.}

\item{progress}{a boolean indicating if the permutation process must be visible.}

\item{index}{a string indicating the association index to compute:
\itemize{
\item 'sri' for Simple ratio index: \eqn{x/x+yAB+yA+yB}
\item 'hw' for Half-weight index: \eqn{x/x+yAB+1/2(yA+yB)}
\item 'sr' for Square root index:\eqn{x/sqr((x+yAB+yA)(x+yAB+yB))}
}}
}
\description{
Warning, the original function (Farine 2017) uses a control factor, the number of focals and the ids of the focals.
}
\details{
Pre-network permutation for focal sampling data, and for symmetric behaviour only.
}
\examples{
head(sim.focal.undirected)
t=perm.ds.focal(sim.focal.undirected,focal=3,ctrl=1,alters=4,nperm=10,progress=TRUE,index='sri')
}
\references{
Farine, D. R. (2017). A guide to null models for animal social network analysis. Methods in ecology and evolution, 8(10), 1309-1320.

Sosa, S. (2018). Social Network Analysis, \emph{in}: Encyclopedia of Animal Cognition and Behavior. Springer.
}
