% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/MetFunctions.R
\name{checkCont}
\alias{checkCont}
\title{Checks a single year for continuity. Called from prepareMet.}
\usage{
checkCont(data)
}
\arguments{
\item{data}{A dataframe containing met file data.}
}
\description{
This is an internal function used by prepareMet to check for
continuity in a single year of a met file.
}
\details{
From tav_amp.for in the APSIM source code:
     One earth orbit around the sun does not take an integral
     number of days - 365 + a small part of a day.  Since the
     Gregorian calendar year is measured as 365 days, a correction
     for this err is made every fourth year by adding one day
     to the length of the year.  This correction is a little too
     much, thus in the centesimal years the correction is not made.
     However this over corrects, so in every fourth centesimal year,
     the correction of adding one day is made.

To summarise -
         If the year is divisible by 4 it is a leap year, unless it is
     a centesimal year, in which case_z it must be divisible by 400.
     i.e.  it is a leap year if either of the conditions hold:
            (1) the year is divisible by 4 but not by 100;
            (2) the year is divisible by 400.
}

