% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find.near.R
\name{find.near}
\alias{find.near}
\alias{findNearLatLon}
\alias{findNearSites}
\title{find nearby sites}
\usage{
findNearLatLon(lat, lon = NULL, nmax = 10, ..., ref = NULL, units = "m")

findNearSites(
  lat,
  lon,
  pollutant = "no2",
  site.type = "rural background",
  nmax = 10,
  ...,
  ref = NULL,
  units = "m"
)
}
\arguments{
\item{lat, lon}{(numeric) The supplied latitude and
longitude.}

\item{nmax}{(numeric) The maximum number of nearest sites
to report, by default 10.}

\item{...}{Other parameters, currently ignored.}

\item{ref}{(\code{data.frame} or similar) The look-up table to
use when identifying nearby locations, and expected to
contain latitude, longitude and any required location
identifier data-series. By default, \code{findNearSites}
uses openair \code{importMeta} output if this is not
supplied but this is a required input for
\code{findNearLatLon}.}

\item{units}{(character) The units to use when reporting
distances to near locations; current options m.}

\item{pollutant}{(character) For \code{findNearSites}
only, the pollutant of interest, by default NO2.}

\item{site.type}{(character) For \code{findNearSites}
only, the monitoring site type, by default Rural
Background.}
}
\value{
\code{find.near} returns \code{data.frame} of near site meta
data.
}
\description{
Function to find nearest locations in a
reference by latitude and longitude.
}
\details{
If investigating air quality in a particular location,
for example a UK Clean Air Zone
(\url{https://www.gov.uk/guidance/driving-in-a-clean-air-zone}),
you may wish to locate an appropriate rural background air quality
monitoring station. \code{findNearSites} locates air quality monitoring
sites with openly available data such as that available from the UK AURN
network (\url{https://uk-air.defra.gov.uk/networks/network-info?view=aurn})
}
\note{
This function uses haversine formula to account
to the Earth's surface curvature, and uses 6371 km as
the radius of earth.
}
\examples{
#find rural background NO2 monitoring sites
#near latitude = 50, longitude = -1

#not run: requires internet
\dontrun{
findNearSites(lat = 50, lon = -1)
}
}
