% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_delay.R
\name{plot_delay}
\alias{plot_delay}
\title{Create plots for the delay multipliers}
\usage{
plot_delay(
  multipliers,
  facets_ncol = 2,
  interval = FALSE,
  interval_color = "blue",
  show.legend = FALSE,
  xlab = "Period",
  ylab = "Delay",
  ...
)
}
\arguments{
\item{multipliers}{A list returned from \code{\link{multipliers}},
in which \code{type} is a positive integer to return delay multipliers.}

\item{facets_ncol}{If a positive integer, it indicates the number of the
columns in the facet. If FALSE, each plot is created separately. The default
is 2.}

\item{interval}{If FALSE (default), no uncertainty intervals are drawn. If a
positive integer, the intervals are this number times the standard error. If
a number between 0 and 1 (e.g. 0.95), the equivalent confidence interval is
drawn (e.g. 95% CI). In case of the confidence intervals, they are based on
the Gaussian distribution.}

\item{interval_color}{The color of the uncertainty intervals. Default is
"blue".}

\item{show.legend}{A logical indicating whether the interval legend is shown.
Default is FALSE.}

\item{xlab, ylab}{Names displayed at the x and y axes respectively. Default is
"Period" and "Delay" respectively.}

\item{...}{Currently unused argument.}
}
\value{
\code{plot_delay} returns a number of \code{\link[ggplot2]{ggplot}}
objects.
}
\description{
Creates plots for the delay multipliers and their uncertainty intervals based
on their estimated standard errors. This is a basic
\code{\link[ggplot2]{ggplot}} with a few customizable parameters.
}
\examples{
ardl_3132 <- ardl(LRM ~ LRY + IBO + IDE, data = denmark, order = c(3,1,3,2))
delay_mult <- multipliers(ardl_3132, type = 12, se = TRUE)

## Simply plot the delay multipliers -----------------------------------

plot_delay(delay_mult)

## Rearrange them ------------------------------------------------------

plot_delay(delay_mult, facets_ncol = 1)

## Add 1 standard deviation uncertainty intervals ----------------------

plot_delay(delay_mult, interval = 1)

## Add 95\% confidence intervals, change color and add legend -----------

plot_delay(delay_mult, interval = 0.95, interval_color = "darkgrey",
           show.legend = TRUE)
}
\seealso{
\code{\link{multipliers}}
}
\author{
Kleanthis Natsiopoulos, \email{klnatsio@gmail.com}
}
\keyword{iplots}
