% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{count_files}
\alias{count_files}
\title{Count files in a project directory}
\usage{
count_files(project_dir, subset = NULL, subset_type = "keep")
}
\arguments{
\item{project_dir}{Character. Directory where project files are stored. File
paths will be used to extract information and must actually exist.}

\item{subset}{Character. Text pattern to mark a subset of files/directories
to either \code{"keep"} or \code{"omit"} (see \code{subset_type})}

\item{subset_type}{Character. Either \code{keep} (default) or \code{omit}
files/directories which match the pattern in \code{subset}.}
}
\value{
A data frame with number of files in a directory
}
\description{
Helper function to explore the number of files in a directory, recursively.
}
\examples{
\dontshow{if (dir.exists("PROJECT_DIR")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
count_files("PROJECT_DIR")
\dontshow{\}) # examplesIf}
}
