% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perm.test.strat.r
\name{perm.test.strat}
\alias{perm.test.strat}
\title{Stratified permutation testing}
\usage{
perm.test.strat(m0list, m1list, r0list, r1list)
}
\arguments{
\item{m0list}{Number of control subjects in each strata}

\item{m1list}{Number of case subjects in each strata}

\item{r0list}{Number of control subjects exposed in each strata}

\item{r1list}{Number of case subjects exposed in each strata}
}
\value{
A permutation p-value, computed under the likelihood ratio test.
}
\description{
Calculates permutation p-values for testing independence in 2x2 case-control tables, while adjusting for categorical covariates. 
Inputs are given as a vector of counts in each strata defined by the covariate(s).
}
\examples{
perm.test.strat(c(7000, 1000), c(11000, 1000), c(50, 30), c(70, 40))
}

