% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ActExtendCosinor.R
\name{ActExtendCosinor}
\alias{ActExtendCosinor}
\title{Extended Cosinor Model for Circadian Rhythmicity}
\usage{
ActExtendCosinor(
  x,
  window = 1,
  lower = c(0, 0, -1, 0, -3),
  upper = c(Inf, Inf, 1, Inf, 27)
)
}
\arguments{
\item{x}{\code{vector} vector of dimension n*1440 which represents n days of 1440 minute activity data}

\item{window}{The calculation needs the window size of the data. E.g window = 1 means each epoch is in one-minute window.}

\item{lower}{A numeric vector of lower bounds on each of the five parameters (in the order of minimum, amplitude, alpha, beta, acrophase) for the NLS. If not given, the default lower bound for each parameter is set to \code{-Inf}.}

\item{upper}{A numeric vector of upper bounds on each of the five parameters (in the order of minimum, amplitude, alpha, beta, acrophase) for the NLS. If not given, the default lower bound for each parameter is set to \code{Inf}}
}
\value{
A list with elements
\item{minimum}{Minimum value of the of the function.}
\item{amp}{amplitude, a measure of half the extend of predictable variation within a cycle. This represents the highest activity one can achieve.}
\item{alpha}{It determines whether the peaks of the curve are wider than the troughs: when alpha is small, the troughs are narrow and the peaks are wide; when alpha is large, the troughs are wide and the peaks are narrow.}
\item{beta}{It dertermines whether the transformed function rises and falls more steeply than the cosine curve: large values of beta produce curves that are nearly square waves.}
\item{acrotime}{acrophase is the time of day of the peak in the unit of the time (hours)}
\item{F_pseudo}{Measure the improvement of the fit obtained by the non-linear estimation of the transformed cosine model}
\item{UpMesor}{Time of day of switch from low to high activity. Represents the timing of the rest- activity rhythm. Lower (earlier) values indicate increase in activity earlier in the day and suggest a more advanced circadian phase.}
\item{DownMesor}{Time of day of switch from high to low activity. Represents the timing of the rest-activity rhythm. Lower (earlier) values indicate decline in activity earlier in the day, suggesting a more advanced circadian phase.}
\item{MESOR}{A measure analogous to the MESOR of the cosine model (or half the deflection of the curve) can be obtained from mes=min+amp/2. However, it goes through the middle of the peak, and is therefore not equal to the MESOR of the cosine model, which is the mean of the data.}
\item{ndays}{Number of days modeled.}
}
\description{
Extended cosinor model based on sigmoidally transformed cosine curve using anti-logistic transformation
}
\examples{
count1 = c(t(example_activity_data$count[1,-c(1,2)]))
cos_coeff = ActExtendCosinor(x = count1, window = 1)
}
\references{
Marler MR, Gehrman P, Martin JL, Ancoli-Israel S. The sigmoidally transformed cosine curve: a mathematical model for circadian rhythms with symmetric non-sinusoidal shapes. Stat Med.
}
