% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ActivePathways.r
\name{export_as_CSV}
\alias{export_as_CSV}
\title{Export the results from ActivePathways as a comma-separated values (CSV) file.}
\usage{
export_as_CSV(res, file_name)
}
\arguments{
\item{res}{the data.table object with ActivePathways results.}

\item{file_name}{location and name of the CSV file to write to.}
}
\description{
Export the results from ActivePathways as a comma-separated values (CSV) file.
}
\examples{
    fname_scores <- system.file("extdata", "Adenocarcinoma_scores_subset.tsv", 
         package = "ActivePathways")
    fname_GMT = system.file("extdata", "hsapiens_REAC_subset.gmt",
         package = "ActivePathways")

    dat <- as.matrix(read.table(fname_scores, header = TRUE, row.names = 'Gene'))
    dat[is.na(dat)] <- 1

    res <- ActivePathways(dat, fname_GMT)
\donttest{
    export_as_CSV(res, "results_ActivePathways.csv")
}
}
