% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{rasterize_data}
\alias{rasterize_data}
\title{Rasterize Spatial Data}
\usage{
rasterize_data(x_coords, y_coords, values, cell_size = 5000, crs, fun = mean)
}
\arguments{
\item{x_coords}{Numeric vector of x-coordinates (e.g., longitude).}

\item{y_coords}{Numeric vector of y-coordinates (e.g., latitude).}

\item{values}{Numeric vector of values associated with each point.}

\item{cell_size}{Numeric. Grid cell size in meters (default: 5000).}

\item{crs}{Character, the coordinate reference system in EPSG format
(e.g., "EPSG:3857").}

\item{fun}{Function to aggregate values in cells (default is `mean`).}
}
\value{
A `terra::SpatRaster` object.
}
\description{
This function converts spatial data with x, y coordinates and a value field
into a raster using a specified resolution and CRS.
}
\examples{

\donttest{
x_coords <- runif(100, -100, 100)
y_coords <- runif(100, -50, 50)
values <- rnorm(100, mean = 10, sd = 5)

rasterize_data(x_coords, y_coords, values,
               cell_size = 5000, crs = "EPSG:3857", fun = mean)
}

}
