#' Dataset: Orchard
#'
#' @description An experiment was carried out to analyze the treatments
#' in orchards applied in the rows and between the rows, in a split-plot
#' scheme according to a randomized block design. For this case, the line
#' and leading are considered the levels of the factor applied in the plots
#' and the treatments are considered the levels of the factor applied in
#' the subplots. Microbial biomass carbon was analyzed.
#'
#' @docType data
#'
#' @usage data(orchard)
#'
#' @format data.frame containing data set
#'   \describe{
#'   \item{\code{A}}{Categorical vector with plot}
#'   \item{\code{B}}{Categorical vector with split-plot}
#'   \item{\code{Bloco}}{Categorical vector with block}
#'   \item{\code{Resp}}{Numeric vector with microbial biomass carbon}
#'   }
#' @keywords datasets
#' @seealso \link{enxofre}, \link{laranja}, \link{mirtilo}, \link{pomegranate}, \link{porco}, \link{sensorial}, \link{simulate1}, \link{simulate2}, \link{simulate3}, \link{tomate}, \link{weather}, \link{phao}, \link{passiflora}, \link{aristolochia}
#'
#'
#' @examples
#' data(orchard)
"orchard"


