% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-paSynoptic.R
\name{pas_isPas}
\alias{pas_isPas}
\title{Test for correct structure in a \emph{pa_synoptic} object}
\usage{
pas_isPas(pas = NULL)
}
\arguments{
\item{pas}{A \emph{pa_synoptic} object.}
}
\value{
\code{TRUE} if \code{pas} has the correct structure, \code{FALSE} otherwise.
}
\description{
The \code{pas} is checked for the "pas" class name
and presence of core metadata columns:
\itemize{
  \item{ID -- Purple Air ID}
  \item{label -- location label}
  \item{sensorType -- PurpleAir sensor type}
  \item{longitude -- decimal degrees E}
  \item{latitude -- decimal degrees N}
  \item{timezone -- Olson timezone}
  \item{countryCode -- ISO 3166-1 alpha-2}
  \item{stateCode -- ISO 3166-2 alpha-2}
  \item{pm25_1hr -- hourly PM2.5}
  \item{pm25_1day -- daily PM2.5}
  \item{temperature -- deg F}
  \item{humidity -- \%}
  \item{pressure -- mb}
  \item{deviceID -- unique device identifier}
  \item{locationID -- unique location identifier}
  \item{deviceDeploymentID -- unique time series identifier}
}
}
\examples{
pas_isPas(example_pas)
pas_isPas(1:10)
}
\seealso{
\link{pas_enhanceData}
}
\keyword{pas}
