% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pat_dygraph.R
\name{pat_dygraph}
\alias{pat_dygraph}
\title{Interactive time series plot}
\usage{
pat_dygraph(
  pat = NULL,
  parameter = "pm25",
  sampleSize = 5000,
  title = NULL,
  xlab = NULL,
  ylab = NULL,
  tlim = NULL,
  rollPeriod = 1,
  showLegend = TRUE,
  colors = NULL,
  timezone = NULL
)
}
\arguments{
\item{pat}{PurpleAir Timeseries \emph{pat} object from \code{pat_createNew()}}

\item{parameter}{Data to display: "pm25", "humidity", "temperature"}

\item{sampleSize}{Either an integer or fraction to determine sample size}

\item{title}{title text}

\item{xlab}{optional title for the x axis}

\item{ylab}{optional title for the y axis}

\item{tlim}{optional vector with start and end times (integer or character
representing YYYYMMDD[HH])}

\item{rollPeriod}{rolling mean to be applied to the data}

\item{showLegend}{logical to toggle display of the legend}

\item{colors}{string vector of colors to be used for plotting}

\item{timezone}{Olson timezone used to interpret \code{tlim}. (Defaults to 
\code{pat} local time.)}
}
\value{
Initiates the interactive dygraph plot in RStudio's 'Viewer' tab.
}
\description{
This function creates interactive graphs that will be displayed
in RStudio's 'Viewer' tab.

The list of available parameters include:

\itemize{
\item{\code{pm25} -- A and B channel PM2.5 (ug/m3)}
\item{\code{temperature} -- temperature (F)}
\item{\code{humidity} -- humidity (\%)}
\item{\code{pressure} -- pressure (hPa)}
}
}
\examples{

\donttest{
library(AirSensor)

North_Bend_Weather <- 
  pat_createNew(
    label = "North Bend Weather", 
    pas = example_pas,
    startdate = 20180801, 
    enddate = 20180901,
    verbose = TRUE
  )

if ( interactive() ) {
  North_Bend_Weather \%>\%
    pat_sample(sampleSize = 1000, setSeed = 1) \%>\%
    pat_dygraph(xlab = "2018", rollPeriod = 6)
}
}
}
\keyword{pa_timeseries}
