% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allelic_series_sumstats.R
\name{COASTSS}
\alias{COASTSS}
\title{COding-variant Allelic Series Test from Summary Statistics}
\usage{
COASTSS(
  anno,
  beta,
  se,
  check = TRUE,
  eps = 1,
  lambda = c(1, 1, 1),
  maf = NULL,
  ld = NULL,
  pval_weights = c(1, 1, 2),
  weights = DEFAULT_WEIGHTS
)
}
\arguments{
\item{anno}{(snps x 1) annotation vector with values in c(0, 1, 2).}

\item{beta}{(snps x 1) vector of effect sizes for the coding genetic variants
within a gene.}

\item{se}{(snps x 1) vector of standard errors for the effect sizes.}

\item{check}{Run input checks? Default: TRUE.}

\item{eps}{Epsilon added to the diagonal of the LD matrix if not positive
definite. Note, epsilon should increase as the sample size decreases.}

\item{lambda}{Optional (3 x 1) vector of inflation factors, one for each
component test. Defaults to a 1s vector, which results in no rescaling.}

\item{maf}{(snps x 1) vector of minor allele frequencies. Although ideally
provided, defaults to the zero vector.}

\item{ld}{(snps x snps) matrix of correlations among the genetic variants.
Although ideally provided, an identity matrix is assumed if not.}

\item{pval_weights}{(3 x 1) vector of relative weights for combining the
component tests to perform the omnibus test.}

\item{weights}{(3 x 1) vector of annotation category weights. The default of
c(1, 1, 2) gives the SKAT test equal weight to the two burden tests.}
}
\value{
Numeric p-value.
}
\description{
Main function for performing the allelic series test from summary statistics.
Performs both Burden and SKAT type tests, then combines the results to
calculate an omnibus p-value. Note that not all tests included in
\code{\link{COAST}} are available when working with summary statistics.
}
\examples{
# Generate data.
data <- DGP(n = 1e3)
sumstats <- CalcSumstats(data = data)

# Run the Coding-variant Allelic Series Test from summary statistics.
results <- COASTSS(
  anno = sumstats$anno,
  beta = sumstats$sumstats$beta, 
  maf = sumstats$maf,
  se = sumstats$sumstats$se,
  ld = sumstats$ld
)
show(results)
}
