% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{mutate}
\alias{mutate}
\title{Add Random Mutations}
\usage{
mutate(pop, mutRate = 2.5e-08, returnPos = FALSE, simParam = NULL)
}
\arguments{
\item{pop}{an object of \code{\link{Pop-class}}}

\item{mutRate}{rate of new mutations}

\item{returnPos}{should the positions of mutations be returned}

\item{simParam}{an object of \code{\link{SimParam}}}
}
\value{
an object of \code{\link{Pop-class}} if 
returnPos=FALSE or a list containing a 
\code{\link{Pop-class}} and a data.frame containing the 
postions of mutations if returnPos=TRUE
}
\description{
Adds random mutations to individuals in a 
population. Note that any existing phenotypes 
or EBVs are kept. Thus, the user will need to run 
\code{\link{setPheno}} and/or \code{\link{setEBV}} 
to generate new phenotypes or EBVs that reflect 
changes introduced by the new mutations.
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=2, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$addTraitA(10)

#Create population
pop = newPop(founderPop, simParam=SP)

#Introduce mutations
pop = mutate(pop, simParam=SP)

}
