% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{getMisc}
\alias{getMisc}
\title{Get miscelaneous information in a population}
\usage{
getMisc(x, node = NULL)
}
\arguments{
\item{x}{\code{\link{Pop-class}}}

\item{node}{character, name of the node to get from the \code{x@misc} slot;
if \code{NULL} the whole \code{x@misc} slot is returned}
}
\value{
The \code{x@misc} slot or its nodes \code{x@misc[[*]][[node]]}
}
\description{
Get miscelaneous information in a population
}
\examples{
founderGenomes <- quickHaplo(nInd = 3, nChr = 1, segSites = 100)
SP <- SimParam$new(founderGenomes)
\dontshow{SP$nThreads = 1L}
basePop <- newPop(founderGenomes)

basePop <- setMisc(basePop, node = "info", value = 1)
basePop@misc
getMisc(x = basePop, node = "info")

basePop <- setMisc(basePop, node = "info2", value = c("A", "B", "C"))
basePop@misc
getMisc(x = basePop, node = "info2")

n <- nInd(basePop)
location <- vector(mode = "list", length = n)
for (ind in seq_len(n)) {
  location[[ind]] <- runif(n = 2, min = 0, max = 100)
}
location
basePop <- setMisc(basePop, node = "location", value = location)
basePop@misc
getMisc(x = basePop, node = "location")

n <- nInd(basePop)
location <- vector(mode = "list", length = n)
for (ind in c(1, 3)) {
  location[[ind]] <- runif(n = 2, min = 0, max = 100)
}
location
basePop <- setMisc(basePop, node = "location", value = location)
basePop@misc
getMisc(x = basePop, node = "location")

getMisc(x = basePop)

}
