% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writePlink.R
\name{writePlink}
\alias{writePlink}
\title{Writes a Pop-class as PLINK files}
\usage{
writePlink(
  pop,
  baseName,
  traits = 1,
  use = "pheno",
  snpChip = 1,
  useQtl = FALSE,
  simParam = NULL,
  ...
)
}
\arguments{
\item{pop}{an object of \code{\link{Pop-class}}}

\item{baseName}{basename for PED and MAP files.}

\item{traits}{an integer indicating the trait to write, a trait name, or a
function of the traits returning a single value.}

\item{use}{what to use for PLINK's phenotype field. Either phenotypes "pheno", 
genetic values "gv", estimated breeding values "ebv", breeding values "bv", 
or random values "rand".}

\item{snpChip}{an integer indicating which SNP chip genotype 
to use}

\item{useQtl}{should QTL genotypes be used instead of a SNP chip. 
If TRUE, snpChip specifies which trait's QTL to use, and thus these 
QTL may not match the QTL underlying the phenotype supplied in traits.}

\item{simParam}{an object of \code{\link{SimParam}}}

\item{...}{additional arguments if using a function for 
traits}
}
\description{
Writes a Pop-class to PLINK PED and MAP files. The arguments 
for this function were chosen for consistency with 
\code{\link{RRBLUP2}}. The base pair coordinate will the locus
position as stored in AlphaSimR and not an actual base pair 
position. This is because AlphaSimR doesn't track base pair 
positions, only relative positions for the loci used in the 
simulation.
}
\examples{
\dontrun{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=15)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$setSexes(sex="yes_rand")
SP$addTraitA(nQtlPerChr=10)
SP$addSnpChip(nSnpPerChr=5)
SP$setVarE(h2=0.5)

#Create population
pop = newPop(rawPop = founderPop)

# Write out PLINK files
writePlink(pop, baseName="test")
}
}
