% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_plot.R
\name{hist_plot}
\alias{hist_plot}
\title{Histogram Plot for Numerical Variables}
\usage{
hist_plot(
  data,
  fill = "skyblue",
  color = "black",
  alpha = 0.7,
  subplot = FALSE,
  nrow = 2,
  margin = 0.1,
  html = FALSE
)
}
\arguments{
\item{data}{The input data frame containing numerical variables.}

\item{fill}{The fill color for the histogram bars (default: "skyblue").}

\item{color}{The border color for the histogram bars (default: "black").}

\item{alpha}{The alpha (transparency) value for the histogram bars (default: 0.7).}

\item{subplot}{A logical argument (default: FALSE) indicating whether to create subplots for each variable.}

\item{nrow}{Number of rows for subplots (used when subplot is TRUE, default: 2).}

\item{margin}{Margin for subplots (used when subplot is TRUE, default: 0.1).}

\item{html}{Whether the output should be in HTML format,used when knitting into HTML. Default is FALSE.}
}
\value{
A list of histogram plot.
}
\description{
This function generates histogram plots for all numerical variables in the input data frame.
It offers a vivid and effective visual summary of the distribution of each numerical variable,
helping in a quick understanding of their central tendency, spread, and shape.
}
\examples{
hist_plot(data = mtcars, fill = "skyblue", color = "black", alpha = 0.7, subplot = FALSE)
}
