% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/APDREcorr.R
\name{plotAPDcorr}
\alias{plotAPDcorr}
\title{Plot APDcorr Posterior Samples and Predicted Effects}
\usage{
plotAPDcorr(
  model,
  hist = TRUE,
  effects = TRUE,
  histcol = c("cyan4", "cyan4", "cyan4", "cyan4"),
  linecol = "red",
  effectcol = c("cyan4", "cyan4", "cyan4", "cyan4"),
  yname = "Focal",
  xname = c("C1", "C2", "C3", "C4")
)
}
\arguments{
\item{model}{Object of class \code{APD} of model output from \code{\link{APDREcorr}} function}

\item{hist}{Logical argument for whether to plot histogram of posterior distribution samples; default=TRUE}

\item{effects}{Logical argument for whether to plot predicted effects; default=TRUE}

\item{histcol}{Colour for posterior distribution histogram}

\item{linecol}{Colour for 95\% HDI line on posterior distribution histogram}

\item{effectcol}{Colour for 95\% HDI ribbon in line plot of predicted effects}

\item{yname}{Character vector of name of focal, to be used in the y axis labels}

\item{xname}{Character vector of name(s) of contingent(s), to be used in the x axis labels}
}
\value{
Histogram plot(s) of samples from posterior distribution for estimated relationship between focal and contingent(s), if plothist=TRUE

Plot of predicted effects (mean and 95\% highest density interval) for relationship between focal APD and contingent(s) APD, if ploteffects=TRUE
}
\description{
Plot histogram of posterior distribution samples and/or predicted effects of parameter estimated from \code{\link{APDREcorr}} function
}
\examples{
data(wolfexample)
data(boarexample)
\donttest{ WolfBoarAPDc<-APDREcorr(focal=wolfexample$Radians, cont1=boarexample$Radians,
    RE1=wolfexample$SamplingPeriod)
    plotAPDcorr(WolfBoarAPDc, yname="Wolf", xname="Boar") }

}
