% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{AM_prior_K_Pois}
\alias{AM_prior_K_Pois}
\title{This function compute the prior on the number of cluster, i.e. occupied component of the mixutre for a Finite Dirichlet process when the prior on the component-weigts of the mixture is a Dirichlet with parameter \code{gamma} (i.e. when unnormailized weights are distributed as Gamma(\eqn{\gamma},1) ) when the prior on the number of componet is Shifted Poisson of parameter \code{Lambda}. See Section 9.1.1 of Argiento de Iorio (2019) for more details.}
\usage{
AM_prior_K_Pois(n, gamma, Lambda)
}
\arguments{
\item{n}{The sample size}

\item{gamma}{The \code{gamma} parameter of the Dirichlet}

\item{Lambda}{The \code{Lambda} parameter of the Poisson}
}
\value{
A vector of length n, reporting the values of the prior on the number of clusters induced by the prior on \code{M} and \code{w}, i.e. \code{p^*_k} for \code{k=1,...,n}. See Section 9.1.1 of Argiento de Iorio (2019) for more details.
}
\description{
There are no default values.
}
\examples{
n <- 82
Lambda <- 10
gam_po <- 0.1550195
prior_K_po <-  AM_prior_K_Pois(n,gam_po,Lambda)
plot(1:n, prior_K_po, type = "n", bty = "l", xlab = "k", ylab = "P(K=k)")
}
\keyword{clusters}
\keyword{number}
\keyword{of}
\keyword{prior}
