% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AntManAPI.R
\name{AM_unipois_mix_hyperparams}
\alias{AM_unipois_mix_hyperparams}
\title{Univariate Poisson Mixture Hyperparameters.}
\usage{
AM_unipois_mix_hyperparams(alpha0, beta0)
}
\arguments{
\item{alpha0}{The shape  hyperparameter \eqn{\alpha_0}.}

\item{beta0}{The  rate hyperparameter \eqn{\beta_0}.}
}
\value{
\preformatted{        A list to be used as \code{mix_kernel_hyperparams} argument for \code{mcmc_fit}.
}
}
\description{
Generate a configuration object that specifies a univariate Poisson mixture kernel and allows to
specify the hyperparameters of the  conjugate Gamma prior, i.e. the kernel is a \eqn{Poisson(\tau) }
and \eqn{\tau\sim Gamma(\alpha_0,\beta_0)}.
In AntMAN we assume the following
parametrization of the Gamma density:
\deqn{p(x\mid a,b )= \frac{b^a x^{a-1}}{\Gamma(a)} \exp\{ -bx \}, \quad x>0  }
}
\details{
Note, by default alpha0=1 and beta0=1.
}
\examples{
AM_unipois_mix_hyperparams (alpha0=2, beta0=0.2)
}
