% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Af_edge_RMSD.R
\name{Af_edge_RMSD}
\alias{Af_edge_RMSD}
\title{Function to calculate the RMSD between sequences over each edge in the AntibodyForest object}
\usage{
Af_edge_RMSD(
  AntibodyForests_object,
  VDJ,
  pdb.dir,
  file.df,
  sequence.region,
  sub.sequence.column,
  chain,
  font.size,
  point.size,
  color,
  output.file
)
}
\arguments{
\item{AntibodyForests_object}{AntibodyForests-object, output from Af_build()}

\item{VDJ}{The dataframe with V(D)J information such as the output of Platypus::VDJ_build() that was used to create the AntibodyForests-object. Must contain columns sample_id, clonotype_id, barcode.}

\item{pdb.dir}{a directory containing PDB files.}

\item{file.df}{a dataframe of pdb filenames (column file_name) to be used and sequence IDs (column sequence) corresponding to the the barcodes in the AntibodyForests-object}

\item{sequence.region}{a character vector of the sequence region to be used to calculate properties. Default is "full.sequence".
\itemize{
\item full.sequence: the full sequence(s) in the PDB file
\item sub.sequence: part of the full sequence, for example the CDR3 region in the PDB file. This sub sequence must be a column in the VDJ dataframe.
\item binding.residues: the binding residues in the PDB file
}}

\item{sub.sequence.column}{a character vector of the column name in the VDJ dataframe containing the sub sequence to be used to calculate properties. Default is NULL.}

\item{chain}{a character vector of the chain to be used to calculate properties. Default is both heavy and light chain
Assuming chain "A" is heavy chain, chain "B" is light chain, and possible chain "C" is the antigen.
\itemize{
\item HC+LC: both heavy and light chain
\item HC: heavy chain, assuming chain A is the heavy chain.
\item LC: light chain, assuming chain B is the light chain.
\item AG: antigen, assuming chain C is the antigen.
\item whole.complex: the whole complex of antibody-antigen (all available chains in the pdb file).
}}

\item{font.size}{The font size of the plot. Default is 12.}

\item{point.size}{The size of the points in the scatterplot. Default is 1.}

\item{color}{The color of the dots in the scatterplot. Default is "black".}

\item{output.file}{string - specifies the path to the output file (PNG of PDF). Defaults to NULL.}
}
\value{
A list with the edge dataframe and a ggplot2 object
}
\description{
This function calculates the RMSD between sequences over each edge in the AntibodyForest object.
}
\examples{
\dontrun{
rmsd_df <- Af_edge_RMSD(AntibodyForests::small_af,
                       VDJ = AntibodyForests::small_vdj,
                       pdb.dir = "~/path/PDBS_superimposed/",
                       file.df = files,
                       sequence.region = "full.sequence",
                       chain = "HC+LC")}
}
