% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CredibleInterval.R
\name{credible_interval}
\alias{credible_interval}
\title{Bayesian credible interval}
\usage{
credible_interval(data, level = 0.95, round_to = 0)
}
\arguments{
\item{data}{Numeric vector containing the output of the MCMC algorithm
for the parameter.}

\item{level}{Probability corresponding to the level of confidence used
for the credible interval, default = 0.95.}

\item{round_to}{Integer indicating the number of decimal places to be used,
default = 0.}
}
\value{
A list with the following components:
\describe{
\item{ci}{Named vector of length 2, with \code{inf} the
lower endpoint of the shortest credible interval as a calendar
year; and \code{sup} the upper endpoint of the shortest credible
interval as a calendar year;}
\item{level}{Confidence level for the credible intervals; and}
\item{call}{Function call.}
}
}
\description{
Computes the shortest credible interval for a single parameter.
}
\details{
A \eqn{(100 * level)}\\% credible interval is an interval
that keeps \eqn{N * (1 - level)} elements of the sample outside the
interval. The \eqn{(100 * level)}\\% credible interval is the shortest
of those intervals.
}
\examples{
  data(Events); attach(Events)
  credible_interval(Event.1)
  credible_interval(Event.12, 0.50)

}
